//Experiment-6
// windows Vista - 32-Bit
//Scilab - 5.5.2


// Aim : A SCILAB program to evaluate performance of medium transmission line using graphical method

clear all;
clc;
// Program to calculate voltage regulation of nominal PI method of medium length transmission line 
// Line parameters are taken from Stevenson as before. One may use any other data using the %commented input functions 
Vr = 220e3;   // input('Enter the value of Vr = ') ;
R =  33.5;   // input('Enter the value of R = ') ;
X = 138;   // input('Enter the value of X = ') ;
pf = 0.9;   // input('Enter the value of pf = ') ;
Pr = 50e6;   // input('Enter the value of pr = ') ;
Y = %i*0.3e-3; // input('Enter the value of Y = ') ;
Z = R + X * %i;
Irmag = Pr/(sqrt(3)*Vr*pf);
pf = 0.5:0.001:1;
Irang = acos (pf);	// Angle in radian
Ir =Irmag * exp (-%i*Irang);
// Irmag is kept constant. Only Ir phasor rotates. -ve sign is used because of lagging power factor %and to indicate that with Vr as reference phasor, angle of Ir should be negative.Irang should be %in radian only. It wil give wrong result, if Irang is in degrees

Ir1 =Irmag * exp (%i*Irang);	// For leading power factor
// Calculations for lagging power factor for medium line length
Vs = Vr/ sqrt (3) + (Ir+(Y/2)*Vr/ sqrt (3))*Z; // all terms are of voltage and are phase values 
VrNLm =abs( Vs / (1+((Y*Z)/2)));
VrFLm= abs (Vr / sqrt (3));
per_vol_regulag = ( (VrNLm -VrFLm) / VrFLm) * 100;
// Calculations for leading power factor for medium line length 
Vs1m = Vr/ sqrt (3) + (Ir1+(Y/2)*Vr/ sqrt (3))*Z; 
// all terms are of voltage and are in phase values 
VrNL1m =abs( Vs1m / (1+((Y*Z)/2)));
per_vol_regulead = ( (VrNL1m -VrFLm) / VrFLm) * 100;
// plot the two waveforms on the same graph 
plot(pf,per_vol_regulag,'r',pf,per_vol_regulead,'*'); 

xlabel('power factor') 
ylabel('voltage regulation')
title('Medium line voltage regulation') 
legend('Lagging Power Factor','Leading Power Factor')
// gtext('Vreg vs lagging pf') 
// gtext('Vreg vs leading pf')
